package nemosofts.voxradio.utils.helper;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemAbout;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.EncryptData;

public class DBHelper extends SQLiteOpenHelper {

    EncryptData encryptData;
    static String DB_NAME = "tb_radios.db";

    SQLiteDatabase db;
    final Context context;

    private static final String TAG_ID = "id";

    private static final String TAG_RADIO_ID = "radio_id";
    private static final String TAG_CAT_ID = "cat_id";
    private static final String TAG_RADIO_TITLE = "radio_title";
    private static final String TAG_RADIO_URL = "radio_url";
    private static final String TAG_IMAGE = "image";
    private static final String TAG_AVG_RATE = "avg_rate";
    private static final String TAG_TOTAL_RATE = "total_rate";
    private static final String TAG_TOTAL_VIEWS = "total_views";
    private static final String TAG_CAT_NAME = "category_name";
    private static final String TAG_PREMIUM = "is_premium";

    // Table Name
    private static final String TABLE_ABOUT = "about";
    private static final String TABLE_RECENT = "recent";

    private static final String TAG_ABOUT_EMAIL = "email";
    private static final String TAG_ABOUT_AUTHOR = "author";
    private static final String TAG_ABOUT_CONTACT = "contact";
    private static final String TAG_ABOUT_WEBSITE = "website";
    private static final String TAG_ABOUT_DESC = "description";
    private static final String TAG_ABOUT_DEVELOPED = "developed";
    private static final String TAG_ABOUT_PUB_ID = "ad_pub";
    private static final String TAG_ABOUT_START_APP_ID = "start_app_id";
    private static final String TAG_ABOUT_IRON_APP_ID = "iron_app_id";
    private static final String TAG_ABOUT_WORTISE_APP_ID = "wortise_app_id";
    private static final String TAG_ABOUT_BANNER_ID = "ad_banner";
    private static final String TAG_ABOUT_INTER_ID = "ad_inter";
    private static final String TAG_ABOUT_NATIVE_ID = "ad_native";
    private static final String TAG_ABOUT_IS_BANNER = "isbanner";
    private static final String TAG_ABOUT_IS_INTER = "isinter";
    private static final String TAG_ABOUT_IS_NATIVE = "isNative";
    private static final String TAG_ABOUT_CLICK = "click";
    private static final String TAG_ABOUT_IS_LANGUAGE = "islanguage";
    private static final String TAG_ABOUT_IS_DOWNLOAD = "isdownload";

    String[] columns_about = new String[]{TAG_ABOUT_EMAIL, TAG_ABOUT_AUTHOR, TAG_ABOUT_CONTACT, TAG_ABOUT_WEBSITE, TAG_ABOUT_DESC, TAG_ABOUT_DEVELOPED,
            TAG_ABOUT_PUB_ID, TAG_ABOUT_START_APP_ID, TAG_ABOUT_IRON_APP_ID, TAG_ABOUT_WORTISE_APP_ID,
            TAG_ABOUT_BANNER_ID, TAG_ABOUT_INTER_ID, TAG_ABOUT_NATIVE_ID, TAG_ABOUT_IS_BANNER, TAG_ABOUT_IS_INTER, TAG_ABOUT_IS_NATIVE,
            TAG_ABOUT_CLICK, TAG_ABOUT_IS_LANGUAGE, TAG_ABOUT_IS_DOWNLOAD};

    private final String[] columns_radio = new String[]{
            TAG_ID, TAG_RADIO_ID, TAG_CAT_ID, TAG_RADIO_TITLE, TAG_RADIO_URL, TAG_IMAGE,
            TAG_TOTAL_RATE, TAG_AVG_RATE, TAG_TOTAL_VIEWS, TAG_CAT_NAME,
            TAG_PREMIUM};

    // Creating table query
    private static final String CREATE_TABLE_RECENT = "create table " + TABLE_RECENT + "(" +
            TAG_ID + " integer PRIMARY KEY AUTOINCREMENT," +
            TAG_RADIO_ID + " TEXT," +
            TAG_CAT_ID + " TEXT," +
            TAG_RADIO_TITLE + " TEXT," +
            TAG_RADIO_URL + " TEXT," +
            TAG_IMAGE + " TEXT," +
            TAG_AVG_RATE + " TEXT," +
            TAG_TOTAL_RATE + " TEXT," +
            TAG_TOTAL_VIEWS + " TEXT," +
            TAG_CAT_NAME + " TEXT," +
            TAG_PREMIUM + " TEXT);";

    // Creating table about
    private static final String CREATE_TABLE_ABOUT = "create table " + TABLE_ABOUT + "(" +
            TAG_ABOUT_EMAIL + " TEXT, " +
            TAG_ABOUT_AUTHOR + " TEXT, " +
            TAG_ABOUT_CONTACT + " TEXT, " +
            TAG_ABOUT_WEBSITE + " TEXT, " +
            TAG_ABOUT_DESC + " TEXT, " +
            TAG_ABOUT_DEVELOPED + " TEXT, " +
            TAG_ABOUT_PUB_ID + " TEXT, " +
            TAG_ABOUT_START_APP_ID + " TEXT, " +
            TAG_ABOUT_IRON_APP_ID + " TEXT, " +
            TAG_ABOUT_WORTISE_APP_ID + " TEXT, " +
            TAG_ABOUT_BANNER_ID + " TEXT, " +
            TAG_ABOUT_INTER_ID + " TEXT, " +
            TAG_ABOUT_NATIVE_ID + " TEXT, " +
            TAG_ABOUT_IS_BANNER + " TEXT, " +
            TAG_ABOUT_IS_INTER + " TEXT, " +
            TAG_ABOUT_IS_NATIVE + " TEXT, " +
            TAG_ABOUT_CLICK + " TEXT, " +
            TAG_ABOUT_IS_LANGUAGE + " TEXT, " +
            TAG_ABOUT_IS_DOWNLOAD + " TEXT);";

    public DBHelper(Context context) {
        super(context, DB_NAME, null, 1);
        encryptData = new EncryptData(context);
        this.context = context;
        db = getWritableDatabase();
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        try {
            db.execSQL(CREATE_TABLE_ABOUT);
            db.execSQL(CREATE_TABLE_RECENT);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("Range")
    public void addToRecent(ItemRadio itemRadio) {
        Cursor cursor_delete = db.query(TABLE_RECENT, columns_radio, null, null, null, null, null);
        if (cursor_delete != null && cursor_delete.getCount() > 20) {
            cursor_delete.moveToFirst();
            db.delete(TABLE_RECENT, TAG_RADIO_ID + "=" + cursor_delete.getString(cursor_delete.getColumnIndex(TAG_RADIO_ID)), null);
        }
        if (cursor_delete != null){
            cursor_delete.close();
        }

        if (Boolean.TRUE.equals(checkRecent(itemRadio.getId()))) {
            db.delete(TABLE_RECENT, TAG_RADIO_ID + "=" + itemRadio.getId(), null);
        }

        String name = itemRadio.getRadioTitle().replace("'", "%27");
        String cat_name = itemRadio.getCategoryName().replace("'", "%27");
        String imageBig = encryptData.encrypt(itemRadio.getImage().replace(" ", "%20"));

        ContentValues contentValues = new ContentValues();
        contentValues.put(TAG_RADIO_ID, itemRadio.getId());
        contentValues.put(TAG_CAT_ID, itemRadio.getCatID());
        contentValues.put(TAG_RADIO_TITLE, name);
        contentValues.put(TAG_RADIO_URL, itemRadio.getRadioUrl());
        contentValues.put(TAG_IMAGE, imageBig);
        contentValues.put(TAG_AVG_RATE, itemRadio.getAverageRating());
        contentValues.put(TAG_TOTAL_RATE, itemRadio.getTotalRate());
        contentValues.put(TAG_TOTAL_VIEWS, itemRadio.getTotalViews());
        contentValues.put(TAG_CAT_NAME, cat_name);
        contentValues.put(TAG_PREMIUM, false);

        db.insert(TABLE_RECENT, null, contentValues);
    }

    private Boolean checkRecent(String id) {
        Cursor cursor = db.query(TABLE_RECENT, columns_radio, TAG_RADIO_ID + "=" + id, null, null, null, null);
        Boolean isFav = cursor != null && cursor.getCount() > 0;
        if (cursor != null) {
            cursor.close();
        }
        return isFav;
    }

    @SuppressLint("Range")
    public String getRecentIDs(String limit) {
        String radioIDs = "";
        Cursor cursor = db.query(TABLE_RECENT, new String[]{TAG_RADIO_ID}, null, null, null, null, TAG_ID + " DESC", limit);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            radioIDs = cursor.getString(cursor.getColumnIndex(TAG_RADIO_ID));
            cursor.moveToNext();
            for (int i = 1; i < cursor.getCount(); i++) {
                radioIDs = radioIDs + "," + cursor.getString(cursor.getColumnIndex(TAG_RADIO_ID));
                cursor.moveToNext();
            }
            cursor.close();
        }
        return radioIDs;
    }

    public void addtoAbout() {
        try {
            db.delete(TABLE_ABOUT, null, null);

            ContentValues contentValues = new ContentValues();
            contentValues.put(TAG_ABOUT_EMAIL, Callback.itemAbout.getEmail());
            contentValues.put(TAG_ABOUT_AUTHOR, Callback.itemAbout.getAuthor());
            contentValues.put(TAG_ABOUT_CONTACT, Callback.itemAbout.getContact());
            contentValues.put(TAG_ABOUT_WEBSITE, Callback.itemAbout.getWebsite());
            contentValues.put(TAG_ABOUT_DESC, Callback.itemAbout.getAppDesc());
            contentValues.put(TAG_ABOUT_DEVELOPED, Callback.itemAbout.getDevelopedBY());

            contentValues.put(TAG_ABOUT_PUB_ID, Callback.publisherAdID);
            contentValues.put(TAG_ABOUT_START_APP_ID, Callback.startappAppId);
            contentValues.put(TAG_ABOUT_IRON_APP_ID, Callback.ironAdsId);
            contentValues.put(TAG_ABOUT_WORTISE_APP_ID, Callback.wortiseAppId);

            contentValues.put(TAG_ABOUT_BANNER_ID, Callback.bannerAdID);
            contentValues.put(TAG_ABOUT_INTER_ID, Callback.interstitialAdID);
            contentValues.put(TAG_ABOUT_NATIVE_ID, Callback.nativeAdID);

            contentValues.put(TAG_ABOUT_IS_BANNER, Callback.isBannerAd);
            contentValues.put(TAG_ABOUT_IS_INTER, Callback.isInterAd);
            contentValues.put(TAG_ABOUT_IS_NATIVE, Callback.isNativeAd);

            contentValues.put(TAG_ABOUT_CLICK, Callback.interstitialAdShow);
            contentValues.put(TAG_ABOUT_IS_LANGUAGE, String.valueOf(Callback.isAppLanguage));

            db.insert(TABLE_ABOUT, null, contentValues);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("Range")
    public Boolean getAbout() {
        Cursor c = db.query(TABLE_ABOUT, columns_about, null, null, null, null, null);

        if (c != null && c.getCount() > 0) {
            c.moveToFirst();
            for (int i = 0; i < c.getCount(); i++) {

                String email = c.getString(c.getColumnIndex(TAG_ABOUT_EMAIL));
                String author = c.getString(c.getColumnIndex(TAG_ABOUT_AUTHOR));
                String contact = c.getString(c.getColumnIndex(TAG_ABOUT_CONTACT));
                String website = c.getString(c.getColumnIndex(TAG_ABOUT_WEBSITE));
                String desc = c.getString(c.getColumnIndex(TAG_ABOUT_DESC));
                String developed = c.getString(c.getColumnIndex(TAG_ABOUT_DEVELOPED));

                Callback.publisherAdID = c.getString(c.getColumnIndex(TAG_ABOUT_PUB_ID));
                Callback.startappAppId = c.getString(c.getColumnIndex(TAG_ABOUT_START_APP_ID));
                Callback.ironAdsId = c.getString(c.getColumnIndex(TAG_ABOUT_IRON_APP_ID));
                Callback.wortiseAppId = c.getString(c.getColumnIndex(TAG_ABOUT_WORTISE_APP_ID));
                Callback.bannerAdID = c.getString(c.getColumnIndex(TAG_ABOUT_BANNER_ID));
                Callback.interstitialAdID = c.getString(c.getColumnIndex(TAG_ABOUT_INTER_ID));
                Callback.nativeAdID = c.getString(c.getColumnIndex(TAG_ABOUT_NATIVE_ID));
                Callback.isBannerAd = Boolean.parseBoolean(c.getString(c.getColumnIndex(TAG_ABOUT_IS_BANNER)));
                Callback.isInterAd = Boolean.parseBoolean(c.getString(c.getColumnIndex(TAG_ABOUT_IS_INTER)));
                Callback.isNativeAd = Boolean.parseBoolean(c.getString(c.getColumnIndex(TAG_ABOUT_IS_NATIVE)));
                Callback.interstitialAdShow = Integer.parseInt(c.getString(c.getColumnIndex(TAG_ABOUT_CLICK)));
                Callback.isAppLanguage = Boolean.parseBoolean(c.getString(c.getColumnIndex(TAG_ABOUT_IS_LANGUAGE)));

                Callback.itemAbout = new ItemAbout(email, author, contact, website, desc, developed);
            }
            c.close();
            return true;
        } else {
            if (c != null) {
                c.close();
            }
            return false;
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }

    @Override
    public synchronized void close () {
        if (db != null) {
            db.close();
            super.close();
        }
    }
}